const READ_4BYTE = 0x98;
const WRITE_4BYTE = 0x99;
const READ_FLOAT = 0xA0;
const WRITE_FLOAT = 0xA1;
const HEAD0 = 0xDA;
const HEAD1 = 0xFE;

class MessageCreator {
    makeHeader(messageSize) {
        var data = [];
        var totalSize = messageSize + 12;
        var sum = 0x01 + (this.getfirstbyte(totalSize) + this.getsecondbyte(totalSize)) ^ 0xFFFF;
        data.push(HEAD0);
        data.push(HEAD1);
        data.push(this.getfirstbyte(totalSize));
        data.push(this.getsecondbyte(totalSize));
        data.push(0x00);
        data.push(0x00);
        data.push(this.getfirstbyte(sum));
        data.push(this.getsecondbyte(sum));
        return data;
    }

    makeTail(messageSum) {
        var sum = 0x01 + (messageSum ^ 0xFFFF);
        var data = [];
        data.push(this.getfirstbyte(sum));
        data.push(this.getsecondbyte(sum));
        data.push(HEAD1);
        data.push(HEAD0);
        return data;
    }

    makeMessage(idx, sidx, value, vsize, file, header) {
        var valuesize = vsize;
        var sumD = 0;
        var data = [];
        if (header == READ_4BYTE) {
            valuesize = 0;
            header = 0x18;
        }

        data.push(header); sumD += header;
        data.push(this.getfirstbyte(valuesize)); sumD += this.getfirstbyte(valuesize);
        data.push(this.getsecondbyte(valuesize)); sumD += this.getsecondbyte(valuesize);
        data.push(this.getthirdbyte(valuesize)); sumD += this.getthirdbyte(valuesize);

        data.push(0x00);
        data.push(0x00);
        data.push(0x00);
        data.push(0x00);

        data.push(this.getfirstbyte(idx)); sumD += this.getfirstbyte(idx);
        data.push(this.getsecondbyte(idx)); sumD += this.getsecondbyte(idx);
        data.push(this.getfirstbyte(sidx)); sumD += this.getfirstbyte(sidx);
        data.push(this.getsecondbyte(sidx)); sumD += this.getsecondbyte(sidx);

        var l;
        if (idx == 9) {
            for (var q = 0; q < valuesize; q++) {
                if ((value.length == 20 && value == "                    ") || (value.length == 28 && value == "                            ")) {
                    data.push(0x00); sumD += 0x00;
                } else {
                    var myByte = (0x000000FF & value.charCodeAt(q));
                    data.push(myByte); sumD += myByte;
                }
            }
        } else {
            if (idx == 13 && vsize == 1024) {
                value.forEach(byte => {
                    data.push(byte);
                    sumD = sumD + byte;
                });
            } else if (idx == 21 && vsize == 20) {
                data.push(this.getfirstbyte(value.onoff)); sumD += this.getfirstbyte(value.onoff); // VAL_1
                data.push(this.getsecondbyte(value.onoff)); sumD += this.getsecondbyte(value.onoff); // VAL_2
                data.push(this.getthirdbyte(value.onoff)); sumD += this.getthirdbyte(value.onoff); // VAL_1
                data.push(this.getfourthbyte(value.onoff)); sumD += this.getfourthbyte(value.onoff); // VAL_2

                data.push(this.getfirstbyte(value.dam)); sumD += this.getfirstbyte(value.dam); // VAL_1
                data.push(this.getsecondbyte(value.dam)); sumD += this.getsecondbyte(value.dam); // VAL_2
                data.push(this.getthirdbyte(value.dam)); sumD += this.getthirdbyte(value.dam); // VAL_1
                data.push(this.getfourthbyte(value.dam)); sumD += this.getfourthbyte(value.dam); // VAL_2

                data.push(this.getfirstbyte(value.freq)); sumD += this.getfirstbyte(value.freq); // VAL_1
                data.push(this.getsecondbyte(value.freq)); sumD += this.getsecondbyte(value.freq); // VAL_2
                data.push(this.getthirdbyte(value.freq)); sumD += this.getthirdbyte(value.freq); // VAL_1
                data.push(this.getfourthbyte(value.freq)); sumD += this.getfourthbyte(value.freq); // VAL_2

                data.push(this.getfirstbyte(value.minR)); sumD += this.getfirstbyte(value.minR); // VAL_1
                data.push(this.getsecondbyte(value.minR)); sumD += this.getsecondbyte(value.minR); // VAL_2
                data.push(this.getthirdbyte(value.minR)); sumD += this.getthirdbyte(value.minR); // VAL_1
                data.push(this.getfourthbyte(value.minR)); sumD += this.getfourthbyte(value.minR); // VAL_2

                data.push(this.getfirstbyte(value.maxR)); sumD += this.getfirstbyte(value.maxR); // VAL_1
                data.push(this.getsecondbyte(value.maxR)); sumD += this.getsecondbyte(value.maxR); // VAL_2
                data.push(this.getthirdbyte(value.maxR)); sumD += this.getthirdbyte(value.maxR); // VAL_1
                data.push(this.getfourthbyte(value.maxR)); sumD += this.getfourthbyte(value.maxR); // VAL_2
            } else {
                for (l = 0; l < (valuesize / 4); l++) {
                    data.push(this.getfirstbyte(value)); sumD += this.getfirstbyte(value);
                    data.push(this.getsecondbyte(value)); sumD += this.getsecondbyte(value);
                    data.push(this.getthirdbyte(value)); sumD += this.getthirdbyte(value);
                    data.push(this.getfourthbyte(value)); sumD += this.getfourthbyte(value);
                }
            }
        }
        return {
            data: data,
            sum: sumD,
            size: valuesize + 12
        }
    }

    getfirstbyte(value) {
        return (value) & 0xFF;
    }

    getsecondbyte(value) {
        return (value >> 8) & 0xFF;
    }

    getthirdbyte(value) {
        return (value >> 16) & 0xFF;
    }

    getfourthbyte(value) {
        return (value >> 24) & 0xFF;
    }
}

const messageCreator = new MessageCreator();

module.exports = {
    messageCreator,
    MessageCreator,
    WRITE_4BYTE,
    WRITE_FLOAT,
    READ_4BYTE,
    READ_FLOAT,
    HEAD0,
    HEAD1
}